*! version 5.0
* 13 August 2018
* NIDS

* THIS IS A FOOD AND NON-FOOD EXPENDITURE DO FILE: 7 OF 14

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "W1 Food_NonFood Expenditure - Master  Food_NonFood Expenditure do file  (1 of 14).do"

*=====================================================================================================================================

* SETTING UP STATA TO RUN DO FILES

clear
cap clear matrix
set more off 

*This .do file cleans and prepares variables required for imputation on non-food expenditures

**********************************************************************
***			Non-Food 1: Preparing for Imputation
**********************************************************************
***				CLEANING
**********************************************************************

use "$DataOUT\tempdata5.dta", clear

egen nfoodtot= rowtotal(e2_2_* )
replace nfoodtot=. if nfoodtot==0

gen tax=e2_2_53
replace tax=0 if tax==.
replace nfoodtot=(nfoodtot-tax)
label var tax "Amount of income Tax paid by the Household (not included in the expenditure measure)"

***Replacing zero's to missing
forvalues a=1/52{
quietly replace e2_2_`a'=. if (e2_1_`a'==1&e2_2_`a'==0)|e2_1_`a'==2
}

*Counts the number of non-food items consumed by each household
egen countNoNFood = rowtotal(e2_1_*)

*Generates logs of the reported consumption values for each non-food item
forvalues a=1/52{
quietly gen e2_2_`a'lg = log(e2_2_`a')
}

**********************************************************************
***				PSU AND DISTRICT LEVEL DATA
**********************************************************************

*Generates psu and district medians and observation counts,for non-food items. The rate of response is also calculated by counting how many households
*in the PSU reported consuming that non-food item, and then dividing the number of reported consumption values by that number

forvalues a=1/52{
*PSU medians and counts
quietly egen npsumedian`a'=median(e2_2_`a') if e2_1_`a'==1, by(w1_cluster)
quietly egen psu`a'count = count(e2_2_`a'), by (w1_cluster)

*District medians and counts
quietly egen ndismedian`a'=median(e2_2_`a') if e2_1_`a'==1, by(w1_dc2011)
quietly egen dis`a'count=count(e2_2_`a'), by(w1_dc2011)

quietly gen n`a'counter = e2_1_`a' if e2_1_`a'==1

*District Response Rates
quietly egen disnsize`a' =count(n`a'counter), by(w1_dc2011)
quietly gen disnrate`a'=dis`a'count/disnsize`a'

*PSU Response Rates
quietly egen psunsize`a' =count(n`a'counter), by(w1_cluster)
quietly gen psunrate`a'=psu`a'count/psunsize`a'
}


*-------------------------------------------------------------------------------------------------------------
save "$DataOUT\tempdata6.dta", replace
